<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\CollectionPoint;

use Exception;

/**
 * Class CollectionPoint
 * @package PolkurierApi\CollectionPoint
 */
class CollectionPoint
{

    public static function setCollectionPoint($datapoint)
    {
        $other_providers = CollectionPointModel::getCollectionPointOtherProviders((int)$datapoint['id_cart'],(int)$datapoint['idcarrier']);
        if (!empty($other_providers)) {
            foreach ($other_providers as $item) {
                CollectionPointModel::deleteCollectionPoint($item['id']);
            }
        }

        $point = [
            'id_cart' => (int)$datapoint['id_cart'],
            'idcarrier' => (int)$datapoint['idcarrier'],
            'providers' => $datapoint['providers'],
            'collection_point' => $datapoint['collection_point'],
            'adres' => $datapoint['adres'],
        ];
        $collection_point = CollectionPointModel::getChosenPoint((int)$datapoint['id_cart'], (int)$datapoint['idcarrier']);
        if (!empty($collection_point)) {
            CollectionPointModel::Update($point, $collection_point['id']);
        } else {
            CollectionPointModel::Insert($point);
        }
    }

    /**
     * @param int $id_cart
     * @throws Exception
     */
    public static function ClearCollectionPoint($id_cart)
    {
        $collection = CollectionPointModel::getAllCollectionPoint((int)$id_cart);
        if (!empty($collection)) {
            foreach ($collection as $item) {
                CollectionPointModel::deleteCollectionPoint($item['id']);
            }
        }
    }
}