<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\CollectionPoint;

/**
 * Class CollectionPointModel
 * @package PolkurierApi\CollectionPoint
 */
final class CollectionPointModel extends CollectionPointSql
{

    /**
     * @param array $data
     * @return array
     */
    public static function PrepareArray($data = [])
    {
        return [
            'id_cart' => (int)$data['id_cart'],
            'idcarrier' => (int)$data['idcarrier'],
            'providers' => pSQL($data['providers']),
            'collection_point' => pSQL($data['collection_point']),
            'adres' => pSQL($data['adres']),
        ];
    }

    /**
     * @param array $data
     * @return int|string
     */
    public static function Insert($data = [])
    {
        return parent::insertSql(
            self::PrepareArray($data)
        );
    }

    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function Update($data, $id)
    {
        return parent::updateSql(
            self::PrepareArray($data), $id
        );
    }

    /**
     * @param int $id_cart
     * @param int $idcarrier
     * @return array|bool|object|null
     */
    public static function getChosenPoint($id_cart, $idcarrier)
    {
        return parent::getCollectionPointByIdCartIdCarrier((int)$id_cart, (int)$idcarrier);
    }

    /**
     * @param int $id_cart
     * @param int $idcarrier
     * @return array|bool|object|null
     */
    public static function getCollectionPointOtherProviders($id_cart, $idcarrier)
    {
        return parent::getCollectionPointOtherProviders((int)$id_cart, (int)$idcarrier);
    }


    /**
     * @param int $id_cart
     * @return array|bool|object|null
     */
    public static function getCollectionPointByIdCart($id_cart)
    {
        return parent::getCollectionPointByIdCart((int)$id_cart);
    }
}