<?php
/**
 * *
 *  * @author     polkurier.pl <api@polkurier.pl>
 *  * @copyright  polkurier.pl
 *  * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 *  * @category   Module
 *  * @package    Presta 1.7
 *  * @subpackage polkurier_import_prestashop
 *  * @link       https://www.polkurier.pl
 *  * @since      1.0.0
 *
 */

namespace PolkurierApi\CollectionPoint\DeliveryPoints;

use PolkurierApi\CollectionPoint\CollectionPointModel;
use Module;
use Order;
use PolkurierApi\CollectionPoint\DeliveryPoint\InpostMachines\Furgonetka\FurgonetkaCollectionPoint;
use PolkurierApi\CollectionPoint\DeliveryPoint\InpostMachines\PrestaModPl\PmInpostPaczkomaty;
use PolkurierApi\CollectionPoint\DeliveryPoint\InpostMachines\Sensbit\SensbitPaczkomaty;

/**
 * Class DeliveryAddressModule
 * @package PolkurierApi\CollectionPoint\DeliveryPoints
 */
final class DeliveryAddressModule
{
    /**
     * @var int
     */
    private $id_order;

    /**
     * DeliveryAddressModule constructor.
     * @param $id_order
     */
    public function __construct($id_order)
    {
        $this->id_order = (int)$id_order;
    }


    public function getDeliveryPoint()
    {
        if (Module::isInstalled('sensbitpaczkomatymap') === true) {
            $collection_point = SensbitPaczkomaty::getIdMachines($this->id_order);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        if (Module::isInstalled('pminpostpaczkomaty') === true) {
            $order = new Order($this->id_order);
            $collection_point = PmInpostPaczkomaty::getIdMachines($order->id_cart);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        if (Module::isInstalled('furgonetka') === true) {
            $order = new Order($this->id_order);
            $collection_point = FurgonetkaCollectionPoint::getIdMachines($order->id_cart);
            if (!is_null($collection_point)) {
                return $collection_point;
            }
        }

        $order = new Order($this->id_order);
        $collection_point = CollectionPointModel::getCollectionPointByIdCart($order->id_cart);
        if (!is_null($collection_point)) {
            return $collection_point['collection_point'];
        }
    }
}