<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi;

/**
 * Class Msg
 * @package PolkurierApi
 *
 */
final class Msg
{
    /**
     * @var array
     */
    private $errors = [];
    
    /**
     * @var array
     */
    private $confirmations = [];
    
    /**
     * @param array $errors
     */
    public function setErrors($errors)
    {
        $this->errors[] = (string)$errors;
    }
    
    /**
     * @param array $confirmations
     */
    public function setConfirmations($confirmations)
    {
        $this->confirmations[] = (string)$confirmations;
    }
    
    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }
    
    /**
     * @return array
     */
    public function getConfirmations()
    {
        return $this->confirmations;
    }
}