<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\ApiMetod;

use Exception;
use PolkurierApiWebServiceApi\Exception\ErrorException;
use PolkurierApiWebServiceApi\Methods\GetCourierPoint;


/**
 * Class CourierPointApi
 * @package PolkurierApi\ApiMetod
 */
class CourierPointApi extends ApiClient
{
    /**
     * @var array
     */
    private $functions = [];

    /**
     * @var array
     */
    private $couriers = [];

    /**
     * @var string
     */
    private $search_query;

    /**
     * @return mixed|void
     */
    public function getPoint()
    {
        if (!empty($this->couriers) && !empty($this->search_query)) {

            try {

                $method = new GetCourierPoint();

                foreach ($this->functions as $item) {
                    $method->setFunctions($item);
                }

                foreach ($this->couriers as $item) {
                    $method->setCouriers($item);
                }

                $method->setSearchQuery($this->search_query);

                $this->webApi()->requestMethod($method);

                return $method->getData();

            } catch (Exception $ex) {
            } catch (ErrorException $ex) {
            }
        }
    }

    /**
     * @param array $functions
     */
    public function setFunctions($functions)
    {
        $this->functions[] = $functions;
    }

    /**
     * @param array $couriers
     */
    public function setCouriers($couriers)
    {
        $this->couriers[] = $couriers;
    }

    /**
     * @param string $search_query
     */
    public function setSearchQuery($search_query)
    {
        $this->search_query = $search_query;
    }

}