<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\Model;

use PolkurierApi\ConfigurationKey;
use Exception;
use Configuration;


/**
 * Class PolkurierConfig
 * @package PolkurierApi\Model
 *
 */
class PolkurierConfig extends Model
{
    /**
     * @param string $key
     * @param $val
     */
    public static function setConfigValue($key, $val)
    {
        Configuration::updateValue(strtoupper($key), $val);
        self::$config_value[strtoupper($key)] = $val;
    }
    
    /**
     * @param $key
     * @return array|mixed|string
     */
    public static function getConfigValue($key)
    {
        if (!isset(self::$config_value[strtoupper($key)])) {
            self::$config_value[strtoupper($key)] = Configuration::get(strtoupper($key));
        }
        return self::$config_value[strtoupper($key)];
    }
    

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
    
    /**
     * @throws Exception
     */
    public static function CheckIsDefined()
    {
        if (empty(self::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_TOKEN))) {
            throw new Exception("Brak danych konfiguracyjnych API: token ");
        }
        
        if (empty(self::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_ACCOUNT))) {
            throw new Exception("Brak danych konfiguracyjnych API: user id");
        }
    }
}
