<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\Model;

use DateTime;

/**
 * Class SqlAbstract
 * @package PolkurierApi\Model\SqlClass
 *
 */
abstract class SqlAbstract
{
    /**
     * @return string
     */
    protected static function CollectionPoint()
    {
        return _DB_PREFIX_ . 'polkurier_collection_point';
    }

    /**
     * @return string
     * @throws \Exception
     */
    protected static function currentTime()
    {
        return (new DateTime("now"))->format('Y-m-d H:i:s');
    }
}