<?php

namespace PolkurierApiWebServiceApi\Methods;

use PolkurierApiWebServiceApi\Response;

/**
 * Class GetCourierPoint
 * @package PolkurierApiWebServiceApi\Methods
 */
class GetCourierPoint extends AbstractMethod
{
    /**
     * @var array
     */
    private $functions = [];

    /**
     * @var array
     */
    private $couriers = [];

    /**
     * @var string|null
     */
    private $search_query;


    /**
     * @return string
     */
    public function getName()
    {
        return 'get_courier_point';
    }

    /**
     * @param $functions
     * @return $this
     */
    public function setFunctions($functions)
    {
        $this->functions[] = $functions;
        return $this;
    }

    /**
     * @param string $couriers
     */
    public function setCouriers($couriers)
    {
        $this->couriers[] = $couriers;
    }


    /**
     * @param $search_query
     */
    public function setSearchQuery($search_query)
    {
        $this->search_query = $search_query;
    }

    /**
     * @return array
     */
    public function getRequestData()
    {
        return [
            'couriers' => $this->couriers,
            'functions' => $this->functions,
            'searchquery' => $this->search_query
        ];
    }

    /**
     * @param Response $response
     * @return $this|GetCourierPoint
     */
    public function setResponseData(Response $response)
    {
        $this->responseData = $response->get('response');
        return $this;
    }
}
