<?php

namespace PolkurierApiWebServiceApi;

use PolkurierApiWebServiceApi\Exception\ErrorException;
use PolkurierApiWebServiceApi\Exception\FatalException;
use PolkurierApiWebServiceApi\Methods\MethodInterface;
use PolkurierApiWebServiceApi\Type\ResponseStatus;
use PolkurierApiWebServiceApi\HTTPClient;

/**
 * Class PolkurierWebService
 * @package PolkurierApiWebServiceApi
 */
class PolkurierWebService
{
    /**
     * @var Auth
     */
    private $auth;

    /**
     * @var HTTPClient HTTPClient
     */
    private $HTTPClient;

    /**
     * @var Config
     */
    private $config;

    /**
     * PolkurierWebService constructor.
     * @param Auth $auth
     * @param Config $config
     */
    public function __construct(Auth $auth, Config $config)
    {
        $this->HTTPClient = new HTTPClient($config);
        $this->config = $config;
        $this->auth = $auth;
    }

    /**
     * @param MethodInterface $method
     * @return Response
     * @throws ErrorException
     */
    public function requestMethod(MethodInterface $method)
    {
        try {
            $request = new Request($method, $this->auth);
            $response = $this->HTTPClient->request($request);
        } catch (FatalException $ex) {
            throw new ErrorException($ex->getMessage());
        }

        if ($response->get('status') !== ResponseStatus::SUCCESS) {
            throw new ErrorException($response->get('response'));
        }
        $method->setResponseData($response);
        return $response;
    }
}
