<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */


/**
 * Class PolkurierConfigAuthView
 */
final class PolkurierConfigAuthView extends PolkurierViewAbstract
{
    /**
     * @var string
     */
    protected static $template = '/views/templates/admin/auth_form.tpl';
    
    /**
     * @return string
     */
    public static function getTemplate()
    {
        return self::$template;
    }
    
    /**
     * @return array
     */
    public static function getFormConfig(){
    
        return [
            'form' => [
                'legend' => [
                    'title' => 'Dane autoryzacyjne',
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'col' => 4,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-user"></i>',
                        'desc' => 'ID KONTA W SERWISIE POLKURIER.PL',
                        'name' => 'POLKURIER_AUTH_API_ACCOUNT',
                        'label' => 'ID KONTA'
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'desc' => 'Do prawidłowego działania modułu wymagane jest podanie ID konta w serwisie POLKURIER.PL oraz aktualnego klucza TOKEN.<br/>Token API można wygenerować w zakładce Panel Klienta > Ustawienia > Token API w serwisie POLKURIER.PL.',
                        'prefix' => '<i class="icon icon-lock"></i>',
                        'name' => 'POLKURIER_AUTH_API_TOKEN',
                        'label' => 'TOKEN'
                    ],
                ],
                'submit' => [
                    'title' => 'Zapisz',
                ],
            ],
        ];
    }
}
