var PolkurierCollectionPoint = {

    InsertCollectionPoint: function (options) {

        options = options || {};
        let props = {
            'id_cart': ID_CART,
            'collection_point': options.id,
            'city': options.city,
            'provider': options.provider,
            'carriers': this.getCurentChecked(),
            'street': options.street,
            'zip': options.zip
        };

        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART,
                'collection_point': props.collection_point,
                'providers': props.provider,
                'idcarrier': props.carriers,
                'adres': props.city + ' ' + props.zip + ' ' + props.street,
            },
            success: function () {
                PolkurierCollectionPoint.HideWarning();
            },
        });
        let string = props.collection_point + '|' + props.city + ' ' + props.zip + ' ' + props.street;
        jQuery('#input_chosen_point_' + props.carriers).val(string);
        jQuery('#chosen_collection_point').html(string);
    },

    UpdateCollectionPoint: function () {
        let carriers = this.getCurentChecked();
        let str = jQuery('#input_chosen_point_' + carriers).val();
        if (str) {
            let res = str.split("|", 2);
            if (res.length > 1) {
                let provider = this.getProvider();
                let adres = res[1];
                let collection_point = res[0];
                jQuery.ajax({
                    type: 'POST',
                    url: POLKURIER_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
                    async: true,
                    cache: false,
                    data: {
                        'id_cart': ID_CART,
                        'collection_point': collection_point,
                        'providers': provider,
                        'idcarrier': carriers,
                        'adres': adres,
                    },
                    success: function (result) {
                    },
                });
            }
        } else {
            this.clearCollectionPoint();
        }
    },

    clearCollectionPoint: function () {
        jQuery.ajax({
            type: 'POST',
            url: POLKURIER_DELETE_COLLECTION_POINT_AJAX_URL + '&token=' + POLKURIER_COLLECTION_POINT_TOKEN,
            async: true,
            cache: false,
            data: {
                'id_cart': ID_CART
            },
            success: function (result) {
            },
        });
    },

    ShowWarning: function () {
        jQuery('#collection-point-warning').show();
    },

    HideWarning: function () {
        jQuery('#collection-point-warning').hide();
    },

    isEmptyChosenPoint: function (carriers) {
        return jQuery('#input_chosen_point_' + carriers).val().length === 0
    },

    getDO: function () {
        if (jQuery('.delivery-options').length) {
            return '.delivery-options';
        }
        return '.delivery-option';
    },

    ButtonControler: function () {
        let carriers = this.getCurentChecked();
        let collectionpointbutton = jQuery('.polkurier-parcellocker-button');
        if (!jQuery('#polkurierapi-carriers-' + carriers).length) {
            collectionpointbutton.hide();
        } else {
            collectionpointbutton.show();
            let chosencollectionpoint = jQuery('#chosen_collection_point');
            chosencollectionpoint.empty();
            chosencollectionpoint.html(jQuery('#input_chosen_point_' + carriers).val());
        }
    },

    getCurentChecked: function () {
        return parseInt(jQuery(this.getDO() + ' input[type="radio"]:checked').val());
    },

    ShowMapCollectionPoint: function (points_map_options) {
        let carriers = this.getCurentChecked();
        Object.assign(points_map_options, {'carriers': carriers});
        Object.assign(points_map_options, {'providers': this.getProvider()});
        Object.assign(points_map_options, {'input_chosen': 'input_chosen_point_' + carriers});
        PolkurierPointsMap.showPointsMap(points_map_options);
    },

    getProvider: function () {
        let curentchecked = this.getCurentChecked();
        let collection = POLKURIER_COLLECTION_POINT_API_CODE || [];
        return collection[curentchecked] || '';
    }
}


jQuery(document).ready(function () {

    PolkurierCollectionPoint.ButtonControler();

    jQuery('button[name="confirmDeliveryOption"]').click(function (event) {
        if (PolkurierCollectionPoint.getProvider()) {
            if (PolkurierCollectionPoint.isEmptyChosenPoint(PolkurierCollectionPoint.getCurentChecked())) {
                PolkurierCollectionPoint.ShowWarning();
                event.preventDefault();
            }
        }
    });

    jQuery(PolkurierCollectionPoint.getDO() + ' input[type="radio"]').on('change', function () {
        if (PolkurierCollectionPoint.getProvider()) {
            PolkurierCollectionPoint.UpdateCollectionPoint();
        } else {
            PolkurierCollectionPoint.clearCollectionPoint();
        }
        PolkurierCollectionPoint.ButtonControler();
    });

    jQuery(document).on('click', '#polkurier-collection-point', function (e) {
        e.preventDefault();
        PolkurierCollectionPoint.ShowMapCollectionPoint(POLKURIER_POINTS_MAP_OPTIONS || []);
    });
});
