<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\ApiMetod;

use ConfigApiPolkurier;
use Exception;
use PolkurierApi\ConfigurationKey;
use PolkurierApi\Model\PolkurierConfig;
use PolkurierApiWebServiceApi\Auth;
use PolkurierApiWebServiceApi\Config;
use PolkurierApiWebServiceApi\Exception\ErrorException;
use PolkurierApiWebServiceApi\Methods\TestAuthApi;
use PolkurierApiWebServiceApi\PolkurierWebService;

/**
 * Class ApiClient
 * @package PolkurierApi\ApiMetod
 *
 */
class ApiClient
{
    /**
     * @var PolkurierConfig
     */
    private $config = null;

    /**
     * ApiClient constructor.
     */
    public function __construct()
    {
        $config = new Config();
        $config->setAuthLogin(PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_ACCOUNT));
        $config->setAuthToken(PolkurierConfig::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_TOKEN));
        $config->setApiUrl(ConfigApiPolkurier::$urlapi);
        $config->setApiTimeout(ConfigApiPolkurier::$apiTimeout);

        $this->config = $config;
    }


    /**
     * @return bool
     * @throws Exception
     */
    public function checkAPI()
    {
        if ($this->getConfig()->isEmpty()) {
            throw new Exception('Połączenie z serwerem nie jest możliwe, proszę poprawić pola: "User ID" lub "Token API"');
        }
        return $this->validateAuthData();
    }


    /**
     * @return Config
     */
    public function getConfig()
    {
        return $this->config;
    }


    /**
     * @return bool
     */
    public function hasEmptyConfig()
    {
        return !is_object($this->getConfig()) || $this->getConfig()->isEmpty();
    }

    /**
     * @return PolkurierWebService
     */
    public function webApi()
    {
        if ($this->hasEmptyConfig()) {
            throw new Exception("Brak Danych konfiguracyjnych API: token i user id");
        }
        try {
            return new PolkurierWebService(new Auth($this->getConfig()), $this->getConfig());
        } catch (ErrorException $ex) {
            throw new Exception($ex->getMessage());
        }
    }

    /**
     * @return bool
     * @throws Exception
     */
    public function validateAuthData()
    {
        try {
            $method = new TestAuthApi();
            $this->webApi()->requestMethod($method);
        } catch (ErrorException $ex) {
            throw new Exception($ex->getMessage());
        }

        if ($method->getData() !== true) {
            throw new Exception('Brak autoryzacji, proszę sprawdzić pola: "User ID" lub "Token API"');
        }
        return true;
    }
}
