<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier_import_prestashop
 * @link       https://www.polkurier.pl
 * @since      1.0.0
 */

namespace PolkurierApi\CollectionPoint;

use Exception;
use PolkurierApi\Model\SqlAbstract;
use Db;

/**
 * Class CollectionPointSql
 * @package PolkurierApi\CollectionPoint
 */
class CollectionPointSql extends SqlAbstract
{
    /**
     * @param array $data
     * @return int|string
     */
    public static function insertSql($data = [])
    {
        Db::getInstance()->insert(parent::CollectionPoint(), $data, false, false, Db::INSERT, false);
    }

    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function updateSql($data, $id)
    {
        return Db::getInstance()->update(parent::CollectionPoint(), $data, 'id = ' . (int)$id, 0, false, false, false);
    }

    /**
     * @param int $id_cart
     * @return array|bool|object|null
     */
    public static function getCollectionPointByIdCart($id_cart)
    {
        try {
            $sql = 'SELECT * FROM ' . self::CollectionPoint() . ' WHERE id_cart = ' . (int)$id_cart . ';';
            return Db::getInstance()->getRow($sql);
        } catch (Exception $e) {
            return [];
        }
    }

    /**
     * @param int $id_cart
     * @param int $idcarrier
     * @return array|bool|object|null
     */
    public static function getCollectionPointByIdCartIdCarrier($id_cart, $idcarrier)
    {
        try {
            $sql = "SELECT * FROM " . self::CollectionPoint() . " WHERE id_cart = " . (int)$id_cart . " AND idcarrier = " . $idcarrier . ";";
            return Db::getInstance()->getRow($sql);
        } catch (Exception $e) {
            return [];
        }
    }

    /**
     * @param int $id_cart
     * @param int $id_carrier
     * @return array
     */
    public static function getCollectionPointOtherProviders($id_cart, $id_carrier)
    {
        try {
            $sql = "SELECT * FROM " . self::CollectionPoint() . " WHERE id_cart = " . (int)$id_cart . " AND idcarrier != " . $id_carrier . ";";
            return Db::getInstance()->executeS($sql);
        } catch (Exception $e) {
            return [];
        }
    }


    /**
     * @param int $id_cart
     * @return array|bool|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getAllCollectionPoint($id_cart)
    {
        try {
            $sql = "SELECT * FROM " . self::CollectionPoint() . " WHERE id_cart = " . (int)$id_cart . ";";
            return Db::getInstance()->executeS($sql);
        } catch (Exception $e) {
            return [];
        }
    }

    /**
     * @param $id
     * @return bool
     * @throws \Exception
     */
    public static function deleteCollectionPoint($id)
    {
        if (!is_numeric($id)) {
            throw new Exception('Id is empty ' . $id);
        }
        return Db::getInstance()->delete(parent::CollectionPoint(), 'id =' . (int)$id, 1, false, false);
    }
}