<?php

namespace PolkurierApiWebServiceApi\Methods;

use PolkurierApiWebServiceApi\Response;
use PolkurierApiWebServiceApi\Util\Arr;

/**
 * Class ApiGetMapToken
 * @package PolkurierApiWebServiceApi\Methods
 */
class ApiGetMapToken extends AbstractMethod
{
    /**
     * @return string
     */
    public function getName()
    {
        return 'get_map_token';
    }

    /**
     * @return array
     */
    public function getRequestData()
    {
        return [];
    }

    /**
     * @param Response $response
     * @return $this|ApiGetMapToken
     */
    public function setResponseData(Response $response)
    {
        $this->responseData = Arr::get($response->get('response'), 'token');
        return $this;
    }
}
