<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\CollectionPoint;

use Exception;
use RuntimeException;
use Polkurier\Model\SqlAbstract;
use Db;

class CollectionPointSql extends SqlAbstract
{

    public static function insertSql($data = []): void
    {
        Db::getInstance()->insert(parent::CollectionPoint(), $data, false, false, Db::INSERT, false);
    }

    public static function updateSql($data, $id)
    {
        return Db::getInstance()->update(parent::CollectionPoint(), $data, 'id = ' . (int)$id, 0, false, false, false);
    }


    public static function getCollectionPointByIdCart($id_cart)
    {
        try {
            $sql = 'SELECT * FROM ' . self::CollectionPoint() . ' WHERE id_cart = ' . (int)$id_cart . ';';
            return Db::getInstance()->getRow($sql);
        } catch (Exception $e) {
        }
        return [];
    }

    public static function getCollectionPointByIdCartProviders($id_cart, $providers)
    {
        try {
            $sql = "SELECT * FROM " . self::CollectionPoint() . " WHERE id_cart = " . (int)$id_cart . " AND providers = '" . $providers . "';";
            return Db::getInstance()->getRow($sql);
        } catch (Exception $e) {
        }
        return [];
    }

    public static function getCollectionPointOtherProviders($id_cart, $providers)
    {
        try {
            $sql = "SELECT * FROM " . self::CollectionPoint() . " WHERE id_cart = " . (int)$id_cart . " AND providers != '" . $providers . "';";
            return Db::getInstance()->executeS($sql);
        } catch (Exception $e) {
        }
        return [];
    }

    public static function getAllCollectionPoint($id_cart)
    {
        try {
            $sql = "SELECT * FROM " . self::CollectionPoint() . " WHERE id_cart = " . (int)$id_cart . ";";
            return Db::getInstance()->executeS($sql);
        } catch (Exception $e) {
        }
        return [];
    }

    public static function deleteCollectionPoint($id)
    {
        if (!is_numeric($id)) {
            throw new RuntimeException('Id is empty ' . $id);
        }
        return Db::getInstance()->delete(parent::CollectionPoint(), 'id =' . (int)$id, 1, false, false);
    }
}