<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

class ShipmentAdditionalServices
{
    public const SMS_NOTIFICATION_RECIPIENT = 'SMS_NOTIFICATION_RECIPIENT';
    public const COURIER_PRINTED_LABEL = 'COURIER_PRINTED_LABEL';
    public const COURIER_WEEK_COLLECTION = 'COURIER_WEEK_COLLECTION';

    private array $services = [];

    public function getServices(): array
    {
        return $this->services;
    }

    public function setServices($services): void
    {
        $this->services[] = $services;
    }

    public function isServices($services): bool
    {
        return in_array($services, $this->services, true);
    }
}