<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Polkurier\Model\Shipment\ShipmentModel;
use Polkurier\Receiver\ReceiverModel;
use Polkurier\SenderOrder\SenderOrderModel;
use PolkurierWebServiceApi\Type\PackType;
use Polkurier\ParcelOrder\ModelParcelOrder;

final class OrderNewSave
{
    private ShipmentModel $shipmentModel;

    private $id_order;

    public function __construct(ShipmentModel $shipmentModel)
    {
        $this->shipmentModel = $shipmentModel;
    }

    public function Save(): void
    {
        $this->SaveOrder();
        
        $this->SaveParcel();
        
        $this->SaveSender();
        
        $this->SaveReceiver();
    }
    

    private function SaveOrder(): void
    {
        $sended_date = null;
        if (!$this->shipmentModel->getShipmentPickup()->isNocourier()) {
            $sended_date = $this->shipmentModel->getShipmentPickup()->getDate() . ' ' . $this->shipmentModel->getShipmentPickup()->getTimefrom() . ' - ' . $this->shipmentModel->getShipmentPickup()->getTimeto();
        }
    
        $status = 'P';
        if(empty($this->shipmentModel->getOrderLabel())){
            $status = 'O';
        }
        $this->id_order = OrdersModel::InsertOrder([
            'created_date' => (new \DateTime('now'))->format(DATE_ISO8601),
            'id_order_presta' => $this->shipmentModel->getPrestaIdOrder(),
            'number_order' => $this->shipmentModel->getPolkurierIdOrder(),
            'number_label' => $this->shipmentModel->getOrderLabel(),
            'shipment_type' => $this->shipmentModel->getShipmentType(),
            'order_price_gross' => $this->shipmentModel->getOrderBrutto(),
            'order_price_net' => $this->shipmentModel->getOrderNetto(),
            'cod_shipment' => $this->shipmentModel->getCodShipment()->getValue(),
            'insurance' => $this->shipmentModel->getInsuranceValue(),
            'sended_date' => $sended_date,
            'content' => $this->shipmentModel->getOrderContent(),
            'status' => $status,
            'traking_url' => $this->shipmentModel->getUrlTracktrace(),
            'status_date' => (new \DateTime('now'))->format(DATE_ISO8601),
            'service_code' => $this->shipmentModel->getServiceCode(),
            'number_account_bank' => $this->shipmentModel->getCodShipment()->getNumber(),
            'return_cod_type' => $this->shipmentModel->getCodShipment()->getType(),
            'return_cod_time' => $this->shipmentModel->getCodShipment()->getTime()
        ]);
    }
    
    /**
     * Dodaje paczki
     */
    private function SaveParcel(): void
    {
        $shipmentpack = $this->shipmentModel->getShipmentPack();
        if(!empty($shipmentpack)){

            foreach ($shipmentpack as $item) {

                $packarray = [
                    'order_id' => $this->id_order,
                    'count' => $item->getAmount(),
                    'no_std' => $item->getType() === PackType::NST ? 1 : 0,
                    'weight' => $item->getWeight(),
                    'length' => $item->getLength(),
                    'height' => $item->getHeight(),
                    'width' => $item->getWidth(),
                ];
                ModelParcelOrder::Insert($packarray);
            }
        }
    }
    
    
    private function SaveSender(): void
    {
        $sender = $this->shipmentModel->getSender();
        SenderOrderModel::InsertOrderSender([
            'order_id' => $this->id_order,
            'company' => $sender->getCompany(),
            'first_name' => $sender->getFirstname(),
            'last_name' => $sender->getLastname(),
            'street' => $sender->getStreet(),
            'house_no' => $sender->getHouseNo(),
            'flat_no' => $sender->getFlatNo(),
            'postcode' => $sender->getPostcode(),
            'city' => $sender->getCity(),
            'contact_name' => $sender->getContactName(),
            'email' => $sender->getEmail(),
            'phone' => $sender->getPhone(),
            'machine_name' => $sender->getStation(),
        ]);
    }
    
    
    private function SaveReceiver(): void
    {
        $receiver = $this->shipmentModel->getReceiver();
        $receiverarray = [
            'order_id' => $this->id_order,
            'company' => $receiver->getCompany(),
            'first_name' => $receiver->getFirstname(),
            'last_name' => $receiver->getLastname(),
            'street' => $receiver->getStreet(),
            'house_no' => $receiver->getHouseNo(),
            'flat_no' => $receiver->getFlatNo(),
            'postcode' => $receiver->getPostcode(),
            'city' => $receiver->getCity(),
            'country_id' => $receiver->getCountryId(),
            'email' => $receiver->getEmail(),
            'phone' => $receiver->getPhone(),
            'machine_name' => $receiver->getStation()
        ];
        ReceiverModel::Insert($receiverarray);
    }

    public function getIdOrder(): int
    {
        return (int)$this->id_order;
    }
}