<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Polkurier\ApiMetod\OrderValuationApi;
use Polkurier\Model\PolkurierConfig;
use Polkurier\Model\Shipment\FormShipment\FormShipmentModel;
use Polkurier\Model\Shipment\ShipmentModel;
use RuntimeException;

final class OrderValuation
{
    private array $dataform = [];

    public function Valuation(): array
    {
        $shipmentmodel = new ShipmentModel();
        (new FormShipmentModel($shipmentmodel,$this->dataform))->SetModel();
        $resp = (new OrderValuationApi())->getValuation($shipmentmodel);
        if (empty($resp)) {
            throw new RuntimeException('Wykonanie wyceny jest nie możliwe.');
        }
        return $resp;
    }

    public function setDataform(array $dataform = []): OrderValuation
    {
        $this->dataform = $dataform;
        return $this;
    }
}