<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use pSQL;
use DateTime;

class OrdersModel extends OrdersSql
{
    public static function InsertOrder($data = [])
    {
        return parent::insertOrder([
            'created_date' => pSQL($data['created_date']),
            'id_order_presta' => pSQL($data['id_order_presta']),
            'number_order' => pSQL($data['number_order']),
            'number_label' => pSQL($data['number_label']),
            'order_price_gross' => pSQL($data['order_price_gross']),
            'order_price_net' => pSQL($data['order_price_net']),
            'sended_date' => pSQL($data['sended_date']),
            'status' => pSQL($data['status']),
            'traking_url' => pSQL($data['traking_url'], true),
            'status_date' => pSQL($data['status_date']),
            'content' => pSQL($data['content']),
            'shipment_type' => pSQL($data['shipment_type']),
            'cod_shipment' => pSQL($data['cod_shipment']),
            'insurance' => pSQL($data['insurance']),
            'service_code' => pSQL($data['service_code']),
            'number_account_bank' => pSQL($data['number_account_bank']),
            'return_cod_type' => pSQL($data['return_cod_type']),
            'return_cod_time' => pSQL($data['return_cod_time'])
        ]);
    }
    

    public static function CanceledOrder(int $id)
    {
        return parent::UpdateOrder(['cancel_order' => 1], $id);
    }

    public static function UpdateTrackingOrder($id, $status_code = '', $delivered_date = null)
    {
        if (is_numeric($id)) {
            $trackingorder['status'] = pSQL($status_code);
            $trackingorder['status_date'] = (new DateTime())->format(DATE_ISO8601);
            if (!is_null($delivered_date)) {
                $trackingorder['delivered_date'] = pSQL($delivered_date);
            }
            return parent::UpdateOrder($trackingorder, $id);
        }
    }
}