<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Db;
use Polkurier\Model\SqlAbstract;
use PrestaShopDatabaseException;

class OrdersSql extends SqlAbstract
{
    public static function insertOrder($data = [])
    {
        Db::getInstance()->insert(parent::Orders(), $data, false, false, Db::INSERT, false);
        return Db::getInstance()->Insert_ID();
    }

    public static function UpdateOrder($data, $order_id)
    {
        try {
            return Db::getInstance()->update(parent::Orders(), $data, 'order_id = ' . (int)$order_id, 0, false, false, false);
        } catch (PrestaShopDatabaseException $e) {
            return null;
        }
    }

    public static function getOrderList($page = 1, $limit = 100, $find = [])
    {
        if ($page < 1) {
            $page = 1;
        }
        
        $query[] = 'SELECT o.created_date, o.delivered_date, o.order_id, o.id_order_presta, o.number_order, o.number_label, o.status, o.status_date,
                o.traking_url, o.cancel_order, po.reference, r.company, r.first_name, r.last_name
                FROM ' . self::Orders() . ' AS o
                INNER JOIN ' . _DB_PREFIX_ . 'orders AS po ON po.id_order = o.id_order_presta
                INNER JOIN ' . parent::Receiver() . ' AS r ON r.order_id = o.order_id';
        
        $sqlfiltr = [];
        
        if (isset($find['presta_order']) && !empty($find['presta_order'])) {
            $sqlfiltr[] = 'po.reference =  \'' . pSQL($find['presta_order']) . '\'';
        }
        
        if (isset($find['polkurier_order']) && !empty($find['polkurier_order'])) {
            $sqlfiltr[] = 'o.number_order =  \'' . pSQL($find['polkurier_order']) . '\'';
        }
        
        if (isset($find['label_order']) && !empty($find['label_order'])) {
            $sqlfiltr[] = 'o.number_label =  \'' . pSQL($find['label_order']) . '\'';
        }
        
        if (!empty($sqlfiltr)) {
            $query[] = 'WHERE ' . implode(' AND ', $sqlfiltr);
        }
        
        $query[] = 'ORDER BY o.created_date DESC LIMIT ' . (((int)$page - 1) * (int)$limit) . ',' . (int)$limit . ';';
        
        return Db::getInstance()->executeS(implode(' ', $query), true);
    }

    public static function getOrderListByOrderPresta($id)
    {
        $sql = 'SELECT * FROM ' . self::Orders() . ' AS o
                WHERE o.id_order_presta = ' . (int)$id . '
                ORDER BY o.created_date;';
        return Db::getInstance()->executeS($sql, true);
    }

    public static function getOrderListStatus($skip_status)
    {
        $sql = 'SELECT * FROM ' . self::Orders() . ' AS o
                WHERE o.status NOT IN (\'' . implode("','", $skip_status) . '\') AND o.cancel_order IS NULL;';
        return Db::getInstance()->executeS($sql, true);
    }

    public static function getCountOrder(): int
    {
        $sql = 'SELECT COUNT(order_id) AS countrecord FROM ' . self::Orders() . ';';
        $return = Db::getInstance()->getRow($sql, true);
        return (int)$return['countrecord'];
    }

    public static function getOrderById(int $order_id)
    {
        try {
            return Db::getInstance()->getRow('SELECT * FROM ' . self::Orders() . ' WHERE order_id = ' . (int)$order_id . ';', true);
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }
}