{*
* @author     polkurier.pl <api@polkurier.pl>
* @copyright  polkurier.pl
* @category   Module
* @package    Presta 8
* @subpackage polkurier
* @link       https://www.polkurier.pl
*}
<div class="bootstrap">
    <div class="panel col-lg-12">
        <a class="btn btn-default" href="{$link->getAdminLink('AdminPolkurierOrderModule', true)|escape:'html':'UTF-8'}">
            <i class="process-icon-back"></i>
            <div>{l s='WSTECZ'}</div>
        </a>
    </div>

    {if $order.cancel_order|default:0 == 1}
        <div class="text-center" style="color: red">
            <h2>ANULOWANE</h2>
        </div>
    {/if}

    <div class="panel col-lg-12">
        <div class="panel-heading">
            Szczegóły zamówienia
        </div>

        <div class="row">
            <div class="col-lg-6">
                <div style="font-weight: bold;" class="text-center row-margin-bottom">
                    {l s='Nadawca'}
                </div>
                {if $sender.machine_name}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            Punkt nadania przesyłki:
                        </div>
                        <div class="col-lg-8">
                            {$sender.machine_name}
                        </div>
                    </div>
                {/if}
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Nazwa firmy:
                    </div>
                    <div class="col-lg-8">
                        {$sender.company}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Imię i nazwisko
                    </div>
                    <div class="col-lg-8">
                        {$sender.first_name} {$sender.last_name}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Adres:
                    </div>
                    <div class="col-lg-8">
                        {$sender.street} {$sender.house_no} {$sender.flat_no}
                    </div>
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Kod pocztowy miasto
                    </div>
                    <div class="col-lg-8">
                        {$sender.postcode} {$sender.city}
                    </div>
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Osoba kontaktowa:
                    </div>
                    <div class="col-lg-8">
                        {$sender.contact_name}
                    </div>
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Telefon:
                    </div>
                    <div class="col-lg-8">
                        {$sender.phone}
                    </div>
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        E-mail:
                    </div>
                    <div class="col-lg-8">
                        {$sender.email}
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div style="font-weight: bold;" class="text-center row-margin-bottom">
                    {l s='Odbiorca'}
                </div>

                {if $receiver.machine_name}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            Punkt odbioru przesyłki:
                        </div>
                        <div class="col-lg-8">
                            {$receiver.machine_name}
                        </div>
                    </div>
                {/if}
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Nazwa firmy'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.company}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Imie i nazwisko'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.first_name} {$receiver.last_name}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Adres'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.street} {$receiver.house_no} {$receiver.flat_no}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Kod pocztowy miasto'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.postcode} {$receiver.city}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Kraj'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.country_name}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Telefon'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.phone}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='E-mail'}:
                    </div>
                    <div class="col-lg-8">
                        {$receiver.email}
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row row-margin-bottom">
        <div class="col-lg-6">
            <div class="panel col-lg-12">
                <div class="panel-heading">
                    Szczegóły zamówienia
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Zamówienie:
                    </div>
                    <div class="col-lg-8">
                        <a href="{$presta.url}">
                            {$presta.reference}
                        </a>
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Kurier:
                    </div>
                    <div class="col-lg-8">
                        {$order.couriers}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Numer zamówienia POLKURIER.PL:
                    </div>
                    <div class="col-lg-8">
                        {$order.number_order}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Cena netto/Cena brutto:
                    </div>
                    <div class="col-lg-8">
                        {$order.order_price_net}/{$order.order_price_gross}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Typ przesyłki:
                    </div>
                    <div class="col-lg-8">
                        {$order.shipment_type_description}
                    </div>
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Opis zawartości:
                    </div>
                    <div class="col-lg-8">
                        {$order.content}
                    </div>
                </div>
            </div>


            <div class="panel col-lg-12">
                <div class="panel-heading">
                    Pobranie/Ubezpieczenie
                </div>

                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        {l s='Ubezpieczenie'}:
                    </div>
                    <div class="col-lg-8">
                        {$order.insurance} PLN
                    </div>
                </div>

                {if $order.cod_shipment > 0}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            {l s='Pobranie'}:
                        </div>
                        <div class="col-lg-8">
                            {$order.cod_shipment} PLN
                        </div>
                    </div>
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            {l s='Rodzaj zwrotu pobrania'}:
                        </div>
                        <div class="col-lg-8">
                            {$order.cod_type}
                        </div>
                    </div>
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            {l s='Konto pobraniowe'}:
                        </div>
                        <div class="col-lg-8">
                            {$order.number_account_bank}
                        </div>
                    </div>
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            {l s='Czas zwrotu pobrania'}:
                        </div>
                        <div class="col-lg-8">
                            {$order.cod_time}
                        </div>
                    </div>
                {else}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            {l s='Pobranie'}:
                        </div>
                        <div class="col-lg-8">
                            Przesyłka bez pobrania
                        </div>
                    </div>
                {/if}
            </div>
        </div>


        <div class="col-lg-6">

            <div class="panel col-lg-12">
                <div class="panel-heading">
                    Przesyłka
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        List przewozowy:
                    </div>
                    <div class="col-lg-8">
                        {if $order.number_label}
                            <a href="{$order.traking_url}">{$order.number_label}</a>
                        {else}
                            BRAK
                        {/if}
                    </div>
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-4 text-right">
                        Status:
                    </div>
                    <div class="col-lg-8">
                        {$order.status_description}
                    </div>
                </div>
            </div>

            <div class="panel col-lg-12">
                <div class="panel-heading">
                    PACZKI
                </div>
                <div class="row row-margin-bottom">
                    <div class="col-lg-2 text-right">
                        Długość
                    </div>
                    <div class="col-lg-2 text-right">
                        Szerokość
                    </div>
                    <div class="col-lg-2 text-right">
                        Wysokość
                    </div>
                    <div class="col-lg-2 text-right">
                        Waga
                    </div>
                    <div class="col-lg-2 text-center">
                        ilość
                    </div>
                    <div class="col-lg-2 text-center">
                        Nstd.
                    </div>
                </div>
                {foreach $parcel as $item}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-2 text-right">
                            {$item.length}
                        </div>
                        <div class="col-lg-2 text-right">
                            {$item.width}
                        </div>
                        <div class="col-lg-2 text-right">
                            {$item.height}
                        </div>
                        <div class="col-lg-2 text-right">
                            {$item.weight}
                        </div>
                        <div class="col-lg-2 text-center">
                            {$item.count}
                        </div>
                        <div class="col-lg-2 text-center">
                            {if $item.no_std == 1}
                                TAK
                            {else}
                                NIE
                            {/if}
                        </div>
                    </div>
                {/foreach}
            </div>


            <div class="panel col-lg-12">
                <div class="panel-heading">
                    {l s='Podjazd kuriera'}
                </div>
                {if $order.sended_date}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-4 text-right">
                            Data/godzina:
                        </div>
                        <div class="col-lg-8">
                            {$order.sended_date}
                        </div>
                    </div>
                {else}
                    <div class="row row-margin-bottom">
                        <div class="col-lg-12 text-center">
                            Zamówię telefonicznie lub samodzielnie dostarczę do przewoźnika
                        </div>
                    </div>
                {/if}
            </div>
        </div>
    </div>
</div>