<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use Polkurier\Model\CountryModel;
use Polkurier\Model\Shipment\CodShipment;
use Polkurier\Model\Shipment\Receiver;
use Polkurier\Model\Shipment\Sender;
use Polkurier\Model\Shipment\SenderCoverAddress;
use Polkurier\Model\Shipment\ShipmenPack;
use Polkurier\Model\Shipment\ShipmentPickup;
use PolkurierWebServiceApi\Entities\COD;
use PolkurierWebServiceApi\Entities\Pack;
use PolkurierWebServiceApi\Entities\Pickup;
use PolkurierWebServiceApi\Entities\Recipient;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Type\PackType;
use PolkurierWebServiceApi\Entities\Sender as ApiSender;
use PolkurierWebServiceApi\Entities\SenderCoverAddress as ApiSenderCoverAddress;
use RuntimeException;

class ApiUtils
{
    public function setPickup(ShipmentPickup $shipmentpickup): Pickup
    {
        $pickup = new Pickup();

        if ($shipmentpickup->isNocourier()) {

            $pickup->setNoCourierOrder(true);

        } else {

            if (!$shipmentpickup->getTimefrom()) {

                $shipmentpickup->setTimefrom('00:00');
            }

            if (!$shipmentpickup->getTimeto()) {

                $shipmentpickup->setTimeto('00:00');
            }

            $pickup->setDate($shipmentpickup->getDate());
            $pickup->setTimeFrom($shipmentpickup->getTimefrom());
            $pickup->setTimeTo($shipmentpickup->getTimeto());
        }

        return $pickup;
    }


    public function setCod(CodShipment $codshipment): COD
    {
        $codclass = new COD();

        if ($codshipment->getValue() === 0.00) {
            return $codclass;
        }

        $codclass->setAmount($codshipment->getValue());

        if (!empty($codshipment->getType())) {
            $codclass->setReturnCod($codshipment->getType());
        }

        if (!empty($codshipment->getTime())) {
            $codclass->setType($codshipment->getTime());
        }

        if (!empty($codshipment->getNumber())) {
            $codclass->setBankAccount($codshipment->getNumber());
        }
        return $codclass;
    }


    public function setPack($shipmentpack = []): array
    {
        $packarray = [];
        /** @var ShipmenPack $item */
        foreach ($shipmentpack as $item) {

            try {
                $pack = new Pack();
                $pack->setLength($item->getLength());
                $pack->setHeight($item->getHeight());
                $pack->setWidth($item->getWidth());
                $pack->setWeight($item->getWeight());
                $pack->setAmount($item->getAmount());

                if ($item->getType() === PackType::NST) {
                    $pack->setType(PackType::NST);
                }
                $packarray[] = $pack;

            } catch (ErrorException $ex) {

                throw new RuntimeException($ex->getMessage());
            }
        }
        return $packarray;
    }


    public function setRecipient(Receiver $receiver): Recipient
    {
        $recipient = new Recipient();
        $recipient->setCompany($receiver->getCompany());
        $recipient->setPerson($receiver->getPerson());
        $recipient->setStreet($receiver->getStreet());
        $recipient->setHouseNumber($receiver->getHouseNo());
        $recipient->setFlatNumber($receiver->getFlatNo());
        $recipient->setPostcode($receiver->getPostcode());
        $recipient->setCity($receiver->getCity());
        $recipient->setPhone($receiver->getPhone());
        $recipient->setEmail($receiver->getEmail());
        $recipient->setMachineName($receiver->getStation());

        if (!empty($receiver->getCountryIso())) {
            $recipient->setCountry($receiver->getCountryIso());
        }
        return $recipient;
    }


    public function setSender(Sender $sender): ApiSender
    {
        $apisender = new ApiSender();
        $apisender->setCompany($sender->getCompany());
        $apisender->setPerson($sender->getPerson());
        $apisender->setStreet($sender->getStreet());
        $apisender->setHouseNumber($sender->getHouseNo());
        $apisender->setFlatNumber($sender->getFlatNo());
        $apisender->setPostcode($sender->getPostcode());
        $apisender->setCity($sender->getCity());
        $apisender->setPhone($sender->getPhone());
        $apisender->setEmail($sender->getEmail());
        $apisender->setMachineName($sender->getStation());
        return $apisender;
    }

    public function setSenderCoverAddress(?SenderCoverAddress $senderCoverAddress)
    {
        if ($senderCoverAddress !== null) {

            $apisendercoveraddress = new ApiSenderCoverAddress();
            $apisendercoveraddress->setCompany($senderCoverAddress->getCompany());
            $apisendercoveraddress->setPerson(trim($senderCoverAddress->getFirstname() . ' ' . $senderCoverAddress->getLastname()));
            $apisendercoveraddress->setStreet($senderCoverAddress->getStreet());
            $apisendercoveraddress->setHouseNumber($senderCoverAddress->getHouseNo());
            $apisendercoveraddress->setFlatNumber($senderCoverAddress->getFlatNo());
            $apisendercoveraddress->setPostalCode($senderCoverAddress->getPostcode());
            $apisendercoveraddress->setCity($senderCoverAddress->getCity());
            $apisendercoveraddress->setPhone($senderCoverAddress->getPhone());
            $apisendercoveraddress->setEmail($senderCoverAddress->getEmail());
            return $apisendercoveraddress;
        }
        return null;
    }


    public static function getStatusText($statusSymbol = ''): string
    {
        switch ($statusSymbol) {
            case "O":
                return "oczekuje";
            case "P":
                return "potwierdzone";
            case "A":
                return "anulowane";
            case "WP":
                return "w przewozie";
            case "D":
                return "dostarczona";
            case "Z":
                return "zwrot do nadawcy";
            case "W":
                return "wyjątek";
            default:
                return "oczekuje";
                break;
        }
    }


    public static function getStatusTextExtended($statusSymbol = ''): string
    {
        switch ($statusSymbol) {
            case "O":
                return "Zlecenie zostało prawidłowo zapisane i oczekuje na płatność.";
            case "P":
                return "Zlecenie zostało prawidłowo zapisane. Wygenerowano list przewozowy. Przesyłka oczekuje na odbiór przez kuriera.";
            case "A":
                return "Przesyłka anulowana.";
            case "WP":
                return "Przesyłka odebrana od nadawcy przez kuriera i jest w drodze do adresata.";
            case "D":
                return "Przesyłka dotarła do adresata.";
            case "Z":
                return "Odbiorca odmówił odebrania przesyłki która zostanie zwrócona nadawcy.";
            case "W":
                return "Status informuje że pojawiły się problemy z dostarczeniem przesyłki. W przypadku wystąpienia tego statusu zalecamy kontakt z BOK w celu szybkiego wyjaśnienia z przewoźnikiem.";
        }
    }
}