<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use RuntimeException;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\ApiGetMapToken;

final class GetMapTokenApi extends ApiClient
{
    public function getToken()
    {
        try {
            $method = new ApiGetMapToken();
            $this->webApi()->requestMethod($method);
            return $method->getData();
        } catch (ErrorException $ex) {
            throw new RuntimeException($ex->getMessage());
        }
    }
}