<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use RuntimeException;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\PickupCourier;

class PickupCourierApi extends ApiClient
{

    private $pickup_date;

    private $ship_form;

    private $courier;

    private $parcel;

    public function getPickup()
    {
        try {

            $pickup_courier_method = new PickupCourier();
            $pickup_courier_method->setPickupdate($this->pickup_date);
            $pickup_courier_method->setShipfrom($this->ship_form);
            $pickup_courier_method->setCourier($this->courier);
            $pickup_courier_method->setParcel($this->parcel);
            $this->webApi()->requestMethod($pickup_courier_method);
            return $pickup_courier_method->getData();

        } catch (ErrorException $ex) {
            throw new RuntimeException($ex->getMessage());
        }
    }

    public function setPickupDate($pickup_date): PickupCourierApi
    {
        $this->pickup_date = $pickup_date;
        return $this;
    }

    public function setShipForm($ship_form): PickupCourierApi
    {
        $this->ship_form = $ship_form;
        return $this;
    }

    public function setCourier($courier): PickupCourierApi
    {
        $this->courier = $courier;
        return $this;
    }

    public function setParcel($parcel): PickupCourierApi
    {
        $this->parcel = $parcel;
        return $this;
    }
}