<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\CoverAddress;

class SenderCoverAddress
{
    public static function saveCoverAddress(array $data = [])
    {
        $coverAddressData = self::getCoverAddressDataFromRequest($data);

        if (self::validateData($coverAddressData) !== true) {
            return 0;
        }

        $id = isset($data['id']) ? (int)$data['id'] : null;

        return $id ? self::updateCoverAddress($coverAddressData, $id) : SenderCoverAddressModel::saveCoverAddress($coverAddressData);
    }


    public static function updateCoverAddress(array $data, int $id): bool
    {
        return SenderCoverAddressModel::updateCoverAddress($data, $id);
    }

    public static function deleteCoverAddress(int $id): bool
    {
        return SenderCoverAddressModel::deleteCoverAddress($id);
    }

    private static function getCoverAddressDataFromRequest(array $data): array
    {
        $coverAddressData = [
            'name' => '',
            'company' => '',
            'first_name' => '',
            'last_name' => '',
            'street' => '',
            'house_no' => '',
            'flat_no' => '',
            'postcode' => '',
            'city' => '',
            'email' => '',
            'phone' => '',
            'is_default_' => 0
        ];

        foreach ($coverAddressData as $key => &$item) {

            if (isset($data[$key])) {

                $item = $data[$key];
            }
        }

        return $coverAddressData;
    }

    private static function validateData($formData): bool
    {
        foreach ($formData as $key => $value) {

            if ($key === 'is_default_') {
                continue;
            }

            if ($key !== 'name' && !empty($value)) {

                return true;
            }
        }
        return false;
    }
}