<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model;

use Country;
use Context;

final class CountryModel
{
    private static array $list = [];
    private static array $list_option = [];

    public static function getList(bool $refresh = false): array
    {
        if (empty(self::$list) || $refresh === true) {

            self::$list = Country::getCountries((int)Context::getContext()->cookie->id_lang, false, false, false);
        }
        return self::$list;
    }


    public static function getListOption(bool $refresh = false): array
    {
        if (empty(self::$list_option) || $refresh === true) {

            self::$list_option = self::getCountryOptions();
        }
        return self::$list_option;
    }


    public static function getIsoById($idCountry): string
    {
        return Country::getIsoById((int)$idCountry);
    }


    public static function getIdByIso($isoCountry): int
    {
        return (int)Country::getByIso((string)$isoCountry);
    }


    public static function getNameById($idCountry): string
    {
        return Country::getNameById((int)Context::getContext()->cookie->id_lang, (int)$idCountry);
    }


    private static function getCountryOptions(): array
    {
        $result = [];

        $list = self::getList();

        if (!empty($list)) {

            foreach ($list as $item) {

                $result[$item['id_country']] = [
                    'id' => $item['id_country'],
                    'iso' => $item['iso_code'],
                    'name' => $item['name']
                ];
            }
        }
        return $result;
    }
}