<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

use Polkurier\CodReturnTime;
use Polkurier\CodType;

final class CodShipment
{
    /**
     * Sposób zwrotu pobrania
     */
    private string $type = CodType::DEFAULT_TYPE;
    
    /**
     * Termin zwrotu pobrania
     */
    private string $time = CodReturnTime::DEFAULT_TYPE;
    
    /**
     * Kwota pobrania
     */
    private float $value = 0.00;

    private $id_cod;

    private $number;

    public function getType(): string
    {
        return $this->type;
    }

    public function setType($type): CodShipment
    {
        $this->type = (string)$type;
        return $this;
    }

    public function getTime(): string
    {
        return $this->time;
    }

    public function setTime($time): CodShipment
    {
        $this->time = (string)$time;
        return $this;
    }

    public function getValue(): float
    {
        return $this->value;
    }

    public function setValue(float $value = 0.00): CodShipment
    {
        $this->value = $value;
        return $this;
    }

    public function getIdCod()
    {
        return $this->id_cod;
    }

    public function setIdCod($id_cod): CodShipment
    {
        $this->id_cod = (int)$id_cod;
        return $this;
    }

    public function getNumber()
    {
        return $this->number;
    }

    public function setNumber($number): CodShipment
    {
        $this->number = preg_replace('/\D/', '', (string)$number);
        return $this;
    }
}