<?php

namespace Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress;

use Polkurier\CollectionPoint\CollectionPointModel;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Furgonetka\FurgonetkaPaczkomaty;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\InpostShipping\InpostShipping;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\PrestaModPl\PmInpostPaczkomaty;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Sensbit\SensbitPaczkomaty;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\InpostMachines\Sensbit\SensbitInpost;
use Polkurier\Model\Shipment\NewShipment\Module\DeliveryAddress\DeliveryPoint\Apaczka\ApaczkaDeliveryPoint;
use Polkurier\Model\Shipment\Receiver;
use Module;
use Order;

final class DeliveryAddressModule
{
    private int $id_order;
    private Receiver $receiver;

    public function __construct(int $id_order, Receiver $receiver)
    {
        $this->id_order = $id_order;
        $this->receiver = $receiver;
    }

    public function setAddress(): void
    {
        if (Module::isInstalled('sensbitpaczkomatymap') === true) {
            $collection_point = SensbitPaczkomaty::getIdMachines($this->id_order);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point);
                return;
            }
        }

        if (Module::isInstalled('sensbitinpost') === true) {
            $collection_point = SensbitInpost::getIdMachines($this->id_order);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point);
                return;
            }
        }

        $order = new Order($this->id_order);
        if (Module::isInstalled('pminpostpaczkomaty') === true) {
            $collection_point = PmInpostPaczkomaty::getMachinesId($order->id_cart);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point);
                return;
            }
        }

        if (Module::isInstalled('furgonetka') === true) {
            $collection_point = FurgonetkaPaczkomaty::getIdMachines($order->id_cart);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point);
                return;
            }
        }

        if (Module::isInstalled('inpostshipping') === true) {
            $collection_point = InpostShipping::getMachinesId($order->id_cart);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point['point']);
                if (!empty($collection_point['email'])) {
                    $this->receiver->setEmail($collection_point['email']);
                }
                if (!empty($collection_point['phone'])) {
                    $this->receiver->setPhone($collection_point['phone']);
                }
                return;
            }
        }

        if (Module::isInstalled('apaczka') === true) {
            $collection_point = ApaczkaDeliveryPoint::getDeliveryPoint($order->id_cart);
            if (!is_null($collection_point)) {
                $this->receiver->setStation($collection_point);
                return;
            }
        }


        $collection_point = CollectionPointModel::getCollectionPointByIdCart($order->id_cart);
        if (!empty($collection_point)) {
            $this->receiver->setStation($collection_point['collection_point']);
        }
    }
}