<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */
namespace Polkurier\Model\Shipment;

abstract class OrderAdres
{
    private $company;

    private $firstname;

    private $lastname;

    private $street;

    private $house_no;

    private $flat_no;

    private $postcode;

    private $city;

    private $countryid;

    private $country_iso;

    private $email;

    private $phone;
    
    /**
     * numer paczkomatu/punktu
     */
    private $station;

    public function getStation()
    {
        return $this->station;
    }

    public function setStation($station): OrderAdres
    {
        $this->station = (string)$station;
        return $this;
    }

    public function getCompany()
    {
        return $this->company;
    }

    public function setCompany($company): OrderAdres
    {
        $this->company = (string)$company;
        return $this;
    }

    public function getFirstname()
    {
        return (string)$this->firstname;
    }

    public function setFirstname($firstname): OrderAdres
    {
        $this->firstname = (string)$firstname;
        return $this;
    }

    public function getLastname()
    {
        return $this->lastname;
    }

    public function setLastname($lastname): OrderAdres
    {
        $this->lastname = (string)$lastname;
        return $this;
    }

    public function getStreet()
    {
        return $this->street;
    }

    public function setStreet($street): OrderAdres
    {
        $this->street = (string)$street;
        return $this;
    }

    public function getHouseNo()
    {
        return $this->house_no;
    }

    public function setHouseNo($house_no): OrderAdres
    {
        $this->house_no = (string)$house_no;
        return $this;
    }

    public function getFlatNo()
    {
        return $this->flat_no;
    }

    public function setFlatNo($flat_no): OrderAdres
    {
        $this->flat_no = (string)$flat_no;
        return $this;
    }

    public function getPostcode()
    {
        return $this->postcode;
    }

    public function setPostcode($postcode): OrderAdres
    {
        $this->postcode = (string)$postcode;
        return $this;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCity($city): OrderAdres
    {
        $this->city = (string)$city;
        return $this;
    }

    public function getCountryId()
    {
        return $this->countryid;
    }

    public function setCountryId($countryid): OrderAdres
    {
        $this->countryid = $countryid;
        return $this;
    }

    public function getCountryIso()
    {
        return $this->country_iso;
    }

    public function setCountryIso($country_iso): OrderAdres
    {
        $this->country_iso = $country_iso;
        return $this;
    }

    public function getEmail()
    {
        return $this->email;
    }

    public function setEmail($email): OrderAdres
    {
        $this->email = (string)$email;
        return $this;
    }

    public function getPhone()
    {
        return $this->phone;
    }

    public function setPhone($phone): OrderAdres
    {
        $this->phone = (string)$phone;
        return $this;
    }

    public function getPerson()
    {
        return trim($this->getFirstname() . ' ' . $this->getLastname());
    }
}