<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

use Polkurier\ParcelOrder\ModelParcelOrder;

final class ShipmentModel
{
    /**
     * @var int
     */
    private $presta_id_order;

    private string $polkurier_id_order = '';
    /**
     * Numer listu przewozowego
     */
    private string $order_label = '';
    /**
     * Adres odbiorcy
     */
    private Receiver $receiver;
    /**
     * Adres nadawcy
     */
    private Sender $sender;
    /**
     * Typ wysyłki
     */
    private string $shipment_type = '';
    /**
     * @var ShipmentModelPack[]
     */
    private array $shipment_Pack = [];
    /**
     * Ubezpieczenie
     */
    private float $insurance_value = 0.00;

    private CodShipment $cod_shipment;
    /**
     * Zawartość przesyłki
     */
    private string $order_content = '';
    /**
     * Przwoźnik
     */
    private string $service_code = '';
    /**
     * koszt przesyłki netto
     */
    private float $order_netto = 0.00;
    /**
     * Koszt przesyłki brutto
     */
    private float $order_brutto = 0.00;
    /**
     * Status zamówienia
     */
    private string $order_status = '';

    private ShipmentPickup $shipment_pickup;

    private string $url_tracktrace = '';

    private ShipmentAdditionalServices $shipmentadditionalservices;

    private ?SenderCoverAddress $senderCoverAddress;

    public function __construct()
    {
        $this->receiver = new Receiver();
        $this->sender = new Sender();
        $this->cod_shipment = new CodShipment();
        $this->shipment_pickup = new ShipmentPickup();
        $this->shipmentadditionalservices = new ShipmentAdditionalServices();
    }

    public function getUrlTracktrace()
    {
        return $this->url_tracktrace;
    }

    public function setUrlTracktrace($url_tracktrace = null): ShipmentModel
    {
        $this->url_tracktrace = (string)$url_tracktrace;
        return $this;
    }

    public function getShipmentPickup(): ShipmentPickup
    {
        return $this->shipment_pickup;
    }

    public function setShipmentPickup(ShipmentPickup $shipment_pickup): ShipmentModel
    {
        $this->shipment_pickup = $shipment_pickup;
        return $this;
    }

    public function getCodShipment(): CodShipment
    {
        return $this->cod_shipment;
    }

    public function setCodShipment(CodShipment $cod_shipment): ShipmentModel
    {
        $this->cod_shipment = $cod_shipment;
        return $this;
    }

    public function getOrderNetto(): float
    {
        return $this->order_netto;
    }

    public function setOrderNetto($order_netto = 0.00): ShipmentModel
    {
        $this->order_netto = (float)$order_netto;
        return $this;
    }

    public function getOrderBrutto(): float
    {
        return $this->order_brutto;
    }

    public function setOrderBrutto($order_brutto = 0.00): ShipmentModel
    {
        $this->order_brutto = (float)$order_brutto;
        return $this;
    }

    public function getOrderStatus()
    {
        return $this->order_status;
    }

    public function setOrderStatus($order_status): ShipmentModel
    {
        $this->order_status = (string)$order_status;
        return $this;
    }

    public function getOrderLabel(): string
    {
        return $this->order_label;
    }

    public function setOrderLabel($order_label): ShipmentModel
    {
        $this->order_label = (string)$order_label;
        return $this;
    }

    public function getServiceCode()
    {
        return $this->service_code;
    }

    public function setServiceCode($service_code): ShipmentModel
    {
        $this->service_code = (string)$service_code;
        return $this;
    }

    public function getOrderContent()
    {
        return $this->order_content;
    }

    public function setOrderContent($order_content): ShipmentModel
    {
        $this->order_content = (string)$order_content;
        return $this;
    }

    public function getPrestaIdOrder(): int
    {
        return $this->presta_id_order;
    }

    public function setPrestaIdOrder($presta_id_order): ShipmentModel
    {
        $this->presta_id_order = (int)$presta_id_order;
        return $this;
    }


    public function getPolkurierIdOrder()
    {
        return $this->polkurier_id_order;
    }

    public function setPolkurierIdOrder($polkurier_id_order): ShipmentModel
    {
        $this->polkurier_id_order = (string)$polkurier_id_order;
        return $this;
    }

    public function getReceiver(): Receiver
    {
        return $this->receiver;
    }

    public function setReceiver(Receiver $receiver): ShipmentModel
    {
        $this->receiver = $receiver;
        return $this;
    }

    public function getSender(): Sender
    {
        return $this->sender;
    }

    public function setSender(Sender $sender): ShipmentModel
    {
        $this->sender = $sender;
        return $this;
    }

    public function getShipmentType(): string
    {
        return $this->shipment_type;
    }

    public function setShipmentType($shipment_type): ShipmentModel
    {
        $this->shipment_type = (string)$shipment_type;
        return $this;
    }

    /**
     * @return ShipmenPack[]
     */
    public function getShipmentPack(): array
    {
        return $this->shipment_Pack;
    }

    public function setShipmentPack(ShipmenPack $shipment_Pack): ShipmentModel
    {
        $this->shipment_Pack[] = $shipment_Pack;
        return $this;
    }

    public function SumWeightShipmentPack(): float
    {
        $packarray = [];
        foreach ($this->getShipmentPack() as $item) {
            $packarray[] = $item->getWeight() * $item->getAmount();
        }
        return (float)array_sum($packarray);
    }

    public function getInsuranceValue(): float
    {
        return $this->insurance_value;
    }

    public function setInsuranceValue(float $insurance_value = 0.00): ShipmentModel
    {
        $this->insurance_value = (float)$insurance_value;
        return $this;
    }

    public function getShipmentadditionalservices(): ShipmentAdditionalServices
    {
        return $this->shipmentadditionalservices;
    }

    public function setShipmentadditionalservices(string $shipmentadditionalservices): void
    {
        $this->shipmentadditionalservices->setServices($shipmentadditionalservices);
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }

    public function getSenderCoverAddress()
    {
        return $this->senderCoverAddress;
    }

    public function setSenderCoverAddress(?SenderCoverAddress $senderCoverAddress): void
    {
        $this->senderCoverAddress = $senderCoverAddress;
    }
}
