<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Exception;

final class RefreshOrderStatusPolkurier
{
    public function Refresh(): void
    {
        $order = OrdersModel::getOrderListStatus(ConfigStatus::$skip_status);
        if (is_array($order)) {

            foreach ($order as $item) {

                $this->UpdateStatus($item);
            }
        }
    }

    private function UpdateStatus($item = []): void
    {
        if (!in_array($item['status'], ConfigStatus::$skip_status) && (int)$item['cancel_order'] === 0) {
            
            try {
                
                $orderstatustraking = new OrderStatusTraking();
                $orderstatustraking->setIdOrderPresta((int)$item['id_order_presta']);
                $orderstatustraking->setNumberOrder($item['number_order']);
                $orderstatustraking->setOrderId((int)$item['order_id']);
                $orderstatustraking->UpdateStatus();
                
            } catch (Exception $ex) {
            }
        }
    }
}