<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Sender;

class SenderListModel
{
    private static array $list = [];

    private static array $list_option = [];

    public static function getList($refresh = false): array
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = SenderModel::getSenderList();
        }
        return self::$list;
    }

    public static function getListOption($refresh = false): array
    {
        if (empty(self::$list_option) || $refresh === true) {

            $list = self::getList();

            if(!empty($list)){

                foreach ($list as $item) {

                    self::$list_option[$item['sender_id']] = [
                        'id' => $item['sender_id'],
                        'name' => $item['name']
                    ];
                }
            }
        }
        return self::$list_option;
    }

    public static function getListToJson()
    {
        return json_encode(self::getList());
    }
}