<?php

namespace PolkurierWebServiceApi\Entities;

class Recipient
{

    private $company;

    private $person;

    private $street;

    private $houseNumber;

    private $flatNumber;

    private $postcode;

    private $city;

    private $email;

    private $phone;

    private $country = 'PL';

    private $machineName;

    public function getCompany(): string
    {
        return $this->company;
    }

    public function setCompany($company): Recipient
    {
        $this->company = $company;
        return $this;
    }

    public function getPerson()
    {
        return $this->person;
    }

    public function setPerson($person): Recipient
    {
        $this->person = $person;
        return $this;
    }

    public function getStreet()
    {
        return $this->street;
    }

    public function setStreet($street): Recipient
    {
        $this->street = $street;
        return $this;
    }

    public function getHouseNumber()
    {
        return $this->houseNumber;
    }

    public function setHouseNumber($houseNumber): Recipient
    {
        $this->houseNumber = $houseNumber;
        return $this;
    }

    public function getFlatNumber()
    {
        return $this->flatNumber;
    }

    public function setFlatNumber($flatNumber): Recipient
    {
        $this->flatNumber = $flatNumber;
        return $this;
    }

    public function getPostcode()
    {
        return $this->postcode;
    }

    public function setPostcode($postcode): Recipient
    {
        $this->postcode = $postcode;
        return $this;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCity($city): Recipient
    {
        $this->city = $city;
        return $this;
    }

    public function getEmail()
    {
        return $this->email;
    }

    public function setEmail($email): Recipient
    {
        $this->email = $email;
        return $this;
    }

    public function getPhone()
    {
        return $this->phone;
    }

    public function setPhone($phone): Recipient
    {
        $this->phone = $phone;
        return $this;
    }

    public function getCountry()
    {
        return $this->country;
    }
    

    public function setCountry($country): Recipient
    {
        $this->country = $country;
        return $this;
    }

    public function getMachineName()
    {
        return $this->machineName;
    }

    public function setMachineName($machineName): Recipient
    {
        $this->machineName = $machineName;
        return $this;
    }

    public function toArray(): array
    {
        return [
            'company' => $this->getCompany(),
            'person' => $this->getPerson(),
            'street' => $this->getStreet(),
            'housenumber' => $this->getHouseNumber(),
            'flatnumber' => $this->getFlatNumber(),
            'postcode' => $this->getPostcode(),
            'city' => $this->getCity(),
            'email' => $this->getEmail(),
            'phone' => $this->getPhone(),
            'country' => $this->getCountry(),
            'machinename' => $this->getMachineName(),
        ];
    }
}