<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace PolkurierWebServiceApi\Methods;

use PolkurierWebServiceApi\Response;
use PolkurierWebServiceApi\Type\ShipmentType;
use PolkurierWebServiceApi\Util\Arr;

class PickupCourier extends AbstractMethod
{
    private  $pickupdate;

    private $courier;

    private $shipfrom;

    private $parcel = ShipmentType::BOX;

    public function getName(): string
    {
        return 'pickup_courier';
    }

    public function setPickupdate($pickupdate): PickupCourier
    {
        $this->pickupdate = $pickupdate;
        return $this;
    }

    public function setCourier($courier): PickupCourier
    {
        $this->courier = $courier;
        return $this;
    }

    public function setShipfrom($shipfrom): PickupCourier
    {
        $this->shipfrom = $shipfrom;
        return $this;
    }

    public function setParcel($parcel): PickupCourier
    {
        $this->parcel = $parcel;
        return $this;
    }

    public function getRequestData(): array
    {
        return [
            'pickupdate' => $this->pickupdate,
            'courier' => $this->courier,
            'shipfrom' => $this->shipfrom,
            'parcel' => $this->parcel
        ];
    }


    public function setResponseData(Response $response)
    {
        $this->responseData = [];
        $response = $response->get('response');
        $this->responseData['pickupdate'] = Arr::get($response, 'pickupdate', false);
        $this->responseData['time'] = Arr::get($response, 'time', []);
        return $this;
    }
}
