<?php

namespace PolkurierWebServiceApi;

use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Exception\FatalException;
use PolkurierWebServiceApi\Methods\MethodInterface;
use PolkurierWebServiceApi\Type\ResponseStatus;

/**
 * Class PolkurierWebService
 * @package PolkurierWebServiceApi
 */
class PolkurierWebService
{
    /**
     * @var Auth
     */
    private $auth;
    /**
     * @var HTTPClient HTTPClient
     */
    private $HTTPClient;

    /**
     * PolkurierWebService constructor.
     * @param \PolkurierWebServiceApi\Auth $auth
     * @param \PolkurierWebServiceApi\Config $config
     */
    public function __construct(Auth $auth, Config $config)
    {
        $this->HTTPClient = new HTTPClient($config);
        $this->auth = $auth;
    }

    /**
     * @param MethodInterface $method
     * @return Response
     * @throws ErrorException
     */
    public function requestMethod(MethodInterface $method)
    {
        try {
            $request = new Request($method, $this->auth);
            $response = $this->HTTPClient->request($request);
        } catch (FatalException $ex) {
            throw new ErrorException($ex->getMessage());
        }

        if ($response->get('status') !== ResponseStatus::SUCCESS) {
            throw new ErrorException($response->get('response'));
        }
        $method->setResponseData($response);
        return $response;
    }
}
