<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

final class ConfigAuthView extends ViewAbstract
{

    protected static string $template = '/views/templates/admin/auth_form.tpl';

    public static function getTemplate(): string
    {
        return self::$template;
    }

    public static function getFormConfig(): array
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Dane autoryzacyjne',
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'col' => 4,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-user"></i>',
                        'desc' => 'ID KONTA W SERWISIE POLKURIER.PL',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_AUTH_API_ACCOUNT,
                        'label' => 'ID KONTA'
                    ],
                    [
                        'col' => 4,
                        'type' => 'text',
                        'desc' => 'Do prawidłowego działania modułu wymagane jest podanie ID konta w serwisie POLKURIER.PL oraz aktualnego klucza TOKEN.<br/>Token API można wygenerować w zakładce Panel Klienta > Ustawienia > Token API w serwisie POLKURIER.PL.',
                        'prefix' => '<i class="icon icon-lock"></i>',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_AUTH_API_TOKEN,
                        'label' => 'TOKEN'
                    ],
                ],
                'submit' => [
                    'title' => 'Zapisz',
                ],
            ],
        ];
    }
}
