<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\CancelOrder;
use RuntimeException;

class CancelOrderApi extends ApiClient
{

    public function cancelOrder($order)
    {
        if (!empty($order)) {
            try {
                $method = new CancelOrder();
                $method->setOrderNumber($order);
                $this->webApi()->requestMethod($method);
                return $method->getData();
            } catch (ErrorException $ex) {
                throw new RuntimeException($ex->getMessage());
            }
        }
    }
}