<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use Polkurier\Model\Shipment\ShipmentAdditionalServices;
use Polkurier\Model\Shipment\ShipmentModel;
use PolkurierWebServiceApi\Entities\CourierWithLabelCourierService;
use PolkurierWebServiceApi\Entities\Pack;
use PolkurierWebServiceApi\Entities\SmsNotificationRecipientCourierService;
use PolkurierWebServiceApi\Entities\WeekCollectionCourierService;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\CreateOrder;
use PolkurierWebServiceApi\Methods\OrderValuation;
use RuntimeException;

class OrderValuationApi extends ApiClient
{

    public function getValuation(ShipmentModel $shipment): array
    {
        try {

            $ordervaluation = new OrderValuation();

            /** @var Pack $item */
            foreach ((new ApiUtils())->setPack($shipment->getShipmentPack()) as $item) {
                $ordervaluation->addPack($item);
            }
            $ordervaluation->setShipmentType($shipment->getShipmentType());

            $ordervaluation->setCOD($shipment->getCodShipment()->getValue());

            $ordervaluation->setCodtype($shipment->getCodShipment()->getTime());

            $ordervaluation->setReturnCod($shipment->getCodShipment()->getType());

            $ordervaluation->setInsurance($shipment->getInsuranceValue());

            $ordervaluation->setPostcodeSender($shipment->getSender()->getPostcode());

            $ordervaluation->setPostcodeRecipient($shipment->getReceiver()->getPostcode());

            if (!empty($shipment->getReceiver()->getCountryIso())) {

                $ordervaluation->setRecipientCountry($shipment->getReceiver()->getCountryIso());
            }

            $this->setShipmentAdditionalServices($ordervaluation, $shipment->getShipmentadditionalservices());

            $this->webApi()->requestMethod($ordervaluation);

            return $ordervaluation->toArray();

        } catch (ErrorException $ex) {
            throw new RuntimeException($ex->getMessage());
        }
    }


    private function setShipmentAdditionalServices(OrderValuation $ordervaluation, ShipmentAdditionalServices $services): void
    {
        if ($services->isServices(ShipmentAdditionalServices::SMS_NOTIFICATION_RECIPIENT)) {
            $ordervaluation->addCourierService(new SmsNotificationRecipientCourierService(true));
        }

        if ($services->isServices(ShipmentAdditionalServices::COURIER_PRINTED_LABEL)) {
            $ordervaluation->addCourierService(new CourierWithLabelCourierService(true));
        }

        if ($services->isServices(ShipmentAdditionalServices::COURIER_WEEK_COLLECTION)) {
            $ordervaluation->addCourierService(new WeekCollectionCourierService(true));
        }
    }
}