<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier;

class CarriersList
{
    private static array $carriers = [
        'INPOST_PACZKOMAT' => [
            'name' => 'Paczkomat Inpost',
            'api_code' => 'INPOST_PACZKOMAT',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'inpost_p.jpg'
        ],
        'PACZKA_W_RUCHU' => [
            'name' => 'ORLEN Paczka',
            'api_code' => 'PACZKA_W_RUCHU',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'logo_orlen_paczka.png'
        ],
        'DPD_POINT' => [
            'name' => 'DPD Pickup',
            'api_code' => 'DPD_POINT',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'dpd_pickup.jpg'
        ],
        'FEDEX_DTR' => [
            'name' => 'FedEx Punkt',
            'api_code' => 'FEDEX_DTR',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'fedex.jpg'
        ],
        'DHL_POINT' => [
            'name' => 'DHL POP',
            'api_code' => 'DHL_POINT',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'logo_kurier_dhl.jpg'
        ],
        'UPS_AP_POINT_POINT' => [
            'name' => 'UPS Access Point',
            'api_code' => 'UPS_AP_POINT_POINT',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'ups.jpg'
        ],
        'POCZTEX_PUNKT' => [
            'name' => 'Pocztex',
            'api_code' => 'POCZTEX_PUNKT',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'pocztex_punkt.jpg'
        ],
        'INPOST_INTERNATIONAL' => [
            'name' => 'Inpost International',
            'api_code' => 'INPOST_INTERNATIONAL',
            'url' => 'https://www.polkurier.pl/sledzenie-przesylek?number=@',
            'img' => 'inpost-international.png'
        ]
    ];

    /**
     * @return string[][]
     */
    public static function getCarriers(): array
    {
        return self::$carriers;
    }
}