<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\CoverAddress;

use Db;
use Exception;
use Polkurier\Model\SqlAbstract;
use Polkurier\Sender\PrestaShopDatabaseException;
use RuntimeException;

class SqlSenderCoverAddress extends SqlAbstract
{
    public static function insertSql(array $data = [])
    {
        if (empty($data['name'])) {
            $currentCoverAddressCount = count(self::getAllSenderCoverAddress());
            $data['name'] = 'Adres na etykiecie #' . ($currentCoverAddressCount + 1);
        }

        self::unsetCurrentDefaultFlagIfNewCoverAddressIsDefault($data);

        Db::getInstance()->insert(parent::SenderCoverAddress(), $data, false, false, Db::INSERT, false);

        return Db::getInstance()->Insert_ID();
    }

    public static function updateSql(array $data, int $id)
    {
        return Db::getInstance()->update(parent::SenderCoverAddress(), $data, 'id = ' . (int)$id, 0, false, false, false);
    }

    public static function getAllSenderCoverAddress(): mixed
    {
        $sql = "SELECT * FROM " . parent::SenderCoverAddress();
        return Db::getInstance()->executeS($sql, true, true);
    }

    public static function getSenderCoverAddressById(int $id)
    {
        try {
            $sql = 'SELECT * FROM ' . self::SenderCoverAddress() . ' WHERE id = ' . (int)$id . ';';
            return Db::getInstance()->getRow($sql);
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }

    public static function deleteSenderCoverAddress(int $id)
    {
        if (!$id) {
            throw new RuntimeException('Id is empty ' . $id);
        }
        
        return Db::getInstance()->delete(parent::SenderCoverAddress(), 'id=' . $id, 1, false, false);
    }

    private static function getDefaultCoverAddress()
    {
        $sql = sprintf('SELECT id FROM %s WHERE is_default = 1', parent::SenderCoverAddress());
        return Db::getInstance()->executeS($sql);
    }


    private static function unsetCurrentDefaultFlagIfNewCoverAddressIsDefault(array $data): void
    {
        if($data['is_default']) {

            $defaultCoverAddressId = self::getDefaultCoverAddress();

            if(!empty($defaultCoverAddressId)) {

                foreach ($defaultCoverAddressId as $coverAddress) {

                    $id = $coverAddress['id'];

                    self::updateSql(['is_default' => 0], $id);
                }
            }
        }
    }
}