<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model;

use Configuration;
use Exception;
use RuntimeException;
use Polkurier\Bank\BankListModel;
use Polkurier\ConfigurationKey;
use Polkurier\CoverAddress\SenderCoverAddressModel;
use Polkurier\Parcel\ParcelListModel;
use Polkurier\ParcelType;
use Polkurier\Sender\SenderListModel;
use Polkurier\UpdateConfigPolkurierApi;

class PolkurierConfig extends Model
{
    private $instance;

    public static function getInstance(): PolkurierConfig
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public static function init(): void
    {
        new UpdateConfigPolkurierApi();
        
        /* Lista zdefiniowanych szablonów paczek */
        self::ParcelList();
        
        /* lista zdefiniowanych adresów nadania */
        self::$sender_list = new SenderListModel();

        self::$sender_cover_address_list = new SenderCoverAddressModel();
        
        /*  Lista kont bankowych */
        self::BankList();
        
        self::getOptionCourierPickupType();
        
        self::loadCountries();
    }

    public function __construct()
    {
        self::init();
    }

    public static function setConfigValue($key, $val): void
    {
        Configuration::updateValue(strtoupper($key), $val);
        self::$config_value[strtoupper($key)] = $val;
    }

    public static function getConfigValue($key)
    {
        if (!isset(self::$config_value[strtoupper($key)])) {
            self::$config_value[strtoupper($key)] = Configuration::get(strtoupper($key));
        }
        return self::$config_value[strtoupper($key)];
    }
    
    /**
     * Lista zdefiniowanych szablonów paczek
     */
    public static function ParcelList(): void
    {
        /* Rodzaj paczek */
        self::$shipment_type = ParcelType::getSelectList();
        
        /* lista paczek + lista do select */
        self::$parcel_template_list = new ParcelListModel();
    }
    
    /**
     * Lista kont bankowych
     */
    public static function BankList(): void
    {
        self::$bank_list = new BankListModel();
    }
    
    private static function loadCountries(): void
    {
        self::$countries = new CountryModel();
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }

    public static function CheckIsDefined(): void
    {
        if (empty(self::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_TOKEN))) {
            throw new RuntimeException("Polkurier moduł: Brak danych konfiguracyjnych API: token ");
        }
        
        if (empty(self::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_ACCOUNT))) {
            throw new RuntimeException("Polkurier moduł: Brak danych konfiguracyjnych API: user id");
        }
    }

    public static function getOptionCourierPickupType(): void
    {
        self::$pickup_courier_type_option = [];
        foreach (self::$pickup_courier_type as $key => $val) {
            self::$pickup_courier_type_option[$key] = [
                "id" => $key,
                "name" => $val === true ? 'Podjazd kuriera' : 'Zamówię samodzielnie'
            ];
        }
    }
}
