<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

final class Receiver extends OrderAdres
{

    private $address_1;

    private $address_2;

    private $country_name;

    public function getAddress1()
    {
        return $this->address_1;
    }

    public function setAddress1($address_1): Receiver
    {
        $this->address_1 = (string)$address_1;
        return $this;
    }

    public function getAddress2()
    {
        return $this->address_2;
    }

    public function setAddress2($address_2): Receiver
    {
        $this->address_2 = (string)$address_2;
        return $this;
    }

    public function getCountryName()
    {
        return $this->country_name;
    }

    public function setCountryName($country_name): Receiver
    {
        $this->country_name = (string)$country_name;
        return $this;
    }
}