<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

class ShipmenPack
{

    private float $length = 0.0;

    private float $width = 0.0;

    private float $height = 0.0;

    private float $weight = 0.0;

    private int $amount = 1;

    private string $type = 'ST';

    public function getLength(): float
    {
        return $this->length;
    }

    public function setLength(float $length): ShipmenPack
    {
        $this->length = $length;
        return $this;
    }

    public function getWidth(): float
    {
        return $this->width;
    }

    public function setWidth(float $width): ShipmenPack
    {
        $this->width = $width;
        return $this;
    }

    public function getHeight(): float
    {
        return $this->height;
    }

    public function setHeight(float $height): ShipmenPack
    {
        $this->height = $height;
        return $this;
    }

    public function getWeight(): float
    {
        return $this->weight;
    }

    public function setWeight(float $weight): ShipmenPack
    {
        $this->weight = $weight;
        return $this;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }

    public function setAmount(int $amount): ShipmenPack
    {
        $this->amount = $amount;
        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): ShipmenPack
    {
        $this->type = $type;
        return $this;
    }

    public function toArray(): array
    {
        return [
            'length' => $this->length,
            'width' => $this->width,
            'height' => $this->height,
            'weight' => $this->weight,
            'amount' => $this->amount,
            'type' => $this->type
        ];
    }
}