<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

final class ShipmentPickup
{
    private $nocourier = false;

    private $date;

    private $timefrom;

    private $timeto;

    public function isNocourier(): bool
    {
        return $this->nocourier;
    }

    public function setNocourier(bool $nocourier = false): ShipmentPickup
    {
        $this->nocourier = $nocourier;
        return $this;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function setDate(string $date): ShipmentPickup
    {
        $this->date = $date;
        return $this;
    }

    public function getTimefrom()
    {
        return $this->timefrom;
    }

    public function setTimefrom(string $timefrom): ShipmentPickup
    {
        $this->timefrom = $timefrom;
        return $this;
    }

    public function getTimeto()
    {
        return $this->timeto;
    }

    public function setTimeto(string $timeto): ShipmentPickup
    {
        $this->timeto = $timeto;
        return $this;
    }
}