<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model;

use DateTime;

abstract class SqlAbstract
{
    protected static function Orders(): string
    {
        return _DB_PREFIX_ . 'pk_orders';
    }

    protected static function Sender(): string
    {
        return _DB_PREFIX_ . 'pk_sender';
    }

    public static function SenderCoverAddress(): string
    {
        return _DB_PREFIX_ . 'pk_sender_cover_address';
    }

    protected static function OrderSender(): string
    {
        return _DB_PREFIX_ . 'pk_order_sender';
    }

    protected static function Receiver(): string
    {
        return _DB_PREFIX_ . 'pk_order_receiver';
    }

    protected static function BankAccount(): string
    {
        return _DB_PREFIX_ . 'pk_bank';
    }

    protected static function Parcel(): string
    {
        return _DB_PREFIX_ . 'pk_parcel';
    }

    protected static function OrderParcel(): string
    {
        return _DB_PREFIX_ . 'pk_order_parcel';
    }

    protected static function CollectionPoint(): string
    {
        return _DB_PREFIX_ . 'pk_collection_point';
    }

    protected static function currentTime(): string
    {
        return (new DateTime("now"))->format('Y-m-d H:i:s');
    }
}