<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Order;

use Polkurier\ApiMetod\ApiUtils;
use Polkurier\CodReturnTime;
use Polkurier\CodType;
use Polkurier\Model\CountryModel;
use Polkurier\Model\PolkurierConfig;
use Polkurier\ParcelOrder\ModelParcelOrder;
use Polkurier\ParcelType;
use Polkurier\Receiver\ReceiverModel;
use Polkurier\SenderOrder\SenderOrderModel;
use Tools;
use Order;

class OrderDetal
{
    private int $idorder;

    private array $dataout = [
        'order' => [],
        'presta' => [],
        'sender' => [],
        'receiver' => [],
        'parcel' => []
    ];

    public function __construct(int $idorder)
    {
        $this->idorder = $idorder;
    }
    
    private function Prepare(): void
    {
        $this->getOrder();
        
        $this->setSender();
        
        $this->setReceiver();
        
        $this->setParcel();
    }
    
    private function getOrder(): void
    {
        $order = OrdersModel::getOrderById($this->idorder);
        $order['shipment_type_description'] = ParcelType::getName($order['shipment_type']);
        $order['status_description'] = ApiUtils::getStatusText($order['status']);
        
        $order['couriers'] = 'NULL';
        if (isset(PolkurierConfig::$couriers[$order['service_code']]['name'])) {
            $order['couriers'] = PolkurierConfig::$couriers[$order['service_code']]['name'];
        }
        
        $order['cod_type'] = '';
        $order['cod_time'] = '';
        
        if ($order['cod_shipment'] > 0) {
            if (!empty($order['return_cod_type'])) {
                $cod_type_name = CodType::NAME;
                if (isset($cod_type_name[$order['return_cod_type']])) {
                    $order['cod_type'] = CodType::NAME[$order['return_cod_type']];
                }
            }
            
            if (!empty($order['return_cod_time'])) {
                $cod_return_time_name = CodReturnTime::NAME;
                if (isset($cod_return_time_name[$order['return_cod_time']])) {
                    $order['cod_time'] = CodReturnTime::NAME[$order['return_cod_time']];
                }
            }
        }
        
        $this->dataout['order'] = $order;
        
        $this->OrderPresta($order['id_order_presta']);
    }
    

    private function OrderPresta($idorder): void
    {
        $order = new Order((int)$idorder);
        $orderarray['reference'] = $order->reference;
        $orderarray['url'] = 'index.php?tab=AdminOrders&id_order=' . (int)$idorder . '&vieworder' . '&token=' . Tools::getAdminTokenLite('AdminOrders');
        $this->dataout['presta'] = $orderarray;
    }
    
    
    private function setSender(): void
    {
        $this->dataout['sender'] = SenderOrderModel::getSenderOrderByOrderId($this->idorder);
    }
    
    private function setReceiver(): void
    {
        $this->dataout['receiver'] = ReceiverModel::getReceiverOrderByOrderId($this->idorder);
        $this->dataout['receiver']['country_name'] = CountryModel::getNameById($this->dataout['receiver']['country_id']);
    }
    
    private function setParcel(): void
    {
        $this->dataout['parcel'] = ModelParcelOrder::getParcelOrderByOrderId($this->idorder);
    }

    public function getDataout(): array
    {
        $this->Prepare();
        return $this->dataout;
    }
}