<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Parcel;

class ParcelModel extends ParcelSql
{

    public static function PrepareArrayParcel($data = []): array
    {
        return [
            'name' => pSQL($data['name']),
            'shipment_type' => pSQL($data['shipment_type']),
            'nstd' => pSQL($data['nstd']),
            'content' => pSQL($data['content']),
            'quantity' => pSQL($data['quantity']),
            'weight' => pSQL($data['weight']),
            'dim_1' => pSQL($data['dim_1']),
            'dim_2' => pSQL($data['dim_2']),
            'dim_3' => pSQL($data['dim_3']),
        ];
    }

    public static function InsertParcel($data = [])
    {
        return parent::insertSql(self::PrepareArrayParcel($data));
    }

    public static function UpdateParcel($data, $id)
    {
        return parent::updateSql(self::PrepareArrayParcel($data), $id);
    }
    
}