<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier;

use PolkurierWebServiceApi\Type\ShipmentType;

final class ParcelType
{
    private static array $listname = [
        ShipmentType::ENVELOPE => 'Koperta',
        ShipmentType::BOX => 'Paczka',
        ShipmentType::PALETTE => 'Paleta'
    ];

    public static function getSelectList(): array
    {
        return [
            ShipmentType::ENVELOPE => [
                'id' => ShipmentType::ENVELOPE,
                'name' => 'Koperta',
                'default' => false
            ],
            ShipmentType::BOX => [
                'id' => ShipmentType::BOX,
                'name' => 'Paczka',
                'default' => true
            ],
            ShipmentType::PALETTE => [
                'id' => ShipmentType::PALETTE,
                'name' => 'Paleta',
                'default' => false
            ]
        ];
    }

    public static function getSelectList2(): array
    {
        return self::$listname;
    }

    public static function getName(string $value)
    {
        if (!empty($value) && isset(self::$listname[$value])) {

            return self::$listname[$value];
        }
    }
}