<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Sender;

class Sender
{
    public static function SaveSenderData($data = [])
    {
        $sender_id = null;

        if (isset($data['sender_id'])) {

            if (is_numeric($data['sender_id'])) {

                $sender_id = $data['sender_id'];
            }
            unset($data['sender_id']);
        }
        
        $senderfield = [
            'name' => '',
            'company' => '',
            'first_name' => '',
            'last_name' => '',
            'street' => '',
            'house_no' => '',
            'flat_no' => '',
            'postcode' => '',
            'city' => '',
            'contact_name' => '',
            'email' => '',
            'phone' => '',
        ];
        
        foreach ($senderfield as $key => &$item) {

            if (isset($data[$key])) {

                $item = $data[$key];
            }
        }
        
        $empty = true;

        foreach ($senderfield as $key => &$item) {

            if (!empty($item)) {

                $empty = false;
            }
        }
        
        if (!$empty) {

            if (is_numeric($sender_id)) {

                return SenderModel::UpdateSender($senderfield, $sender_id);
            }
            return SenderModel::InsertSender($senderfield);
        }
    }
}