<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 8
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier;

use Polkurier\ApiMetod\AvailableCarriersApi;
use Polkurier\Model\PolkurierConfig;
use Exception;

/**
 * Aktualizuje dane z API
 */
class UpdateConfigPolkurierApi
{

    public function __construct()
    {
        $this->getCouriers();
    }

    /**
     * Dostępni przewoźnicy
     */
    private function getCouriers(): void
    {
        $couriers = [];
        try{

            $resp = (new AvailableCarriersApi())->getCarriers();

            if (!empty($resp)) {

                foreach ($resp as $carrier) {
                    $servicecode = $carrier->getServicecode();
                    $couriers[$servicecode] = [
                        'id' => $servicecode,
                        'name' => $carrier->getName()
                    ];
                }
            }
        }catch (Exception $ex){
        }

        PolkurierConfig::$couriers = $couriers;
    }
}